#include<bits/stdc++.h>
using namespace std;

typedef long long ll;
typedef pair<ll, ll> pll;

const int MAXN = 5e5 + 5;
const ll INF = 1e18;

int N, K;
ll X[MAXN], A[MAXN], B[MAXN], pref[MAXN], suff[MAXN];
pll seg[4*MAXN];

void build(int x, int l, int r) {
    if(l == r) {
        seg[x] = {B[l], l};
        return;
    }
    int mid = (l + r) / 2;
    build(2*x, l, mid);
    build(2*x+1, mid+1, r);
    seg[x] = max(seg[2*x], seg[2*x+1]);
}

pll query(int x, int l, int r, int ql, int qr) {
    if(l > qr || r < ql) return {-INF, -1};
    if(l >= ql && r <= qr) return seg[x];
    int mid = (l + r) / 2;
    return max(query(2*x, l, mid, ql, qr), query(2*x+1, mid+1, r, ql, qr));
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    cin >> N >> K;
    for(int i=1; i<=K; i++) {
        int a;
        cin >> a;
        A[a] = 1;
    }
    for(int i=1; i<=N; i++) {
        cin >> X[i];
        pref[i] = pref[i-1] + X[i];
    }
    for(int i=N; i>=1; i--) {
        suff[i] = suff[i+1] + X[i];
    }
    for(int i=1; i<=N; i++) {
        B[i] = B[i-1] + (A[i] ? X[i] : 0);
    }
    build(1, 1, N);
    ll ans = 0;
    for(int i=1; i<=N; i++) {
        if(!A[i]) continue;
        ll l = 1, r = i, best = i;
        while(l <= r) {
            ll mid = (l + r) / 2;
            pll q = query(1, 1, N, mid, i);
            if(q.first - B[mid-1] >= pref[i] - pref[mid-1]) {
                best = mid;
                r = mid - 1;
            } else {
                l = mid + 1;
            }
        }
        ans = max(ans, i - best + 1);
        l = i, r = N;
        best = i;
        while(l <= r) {
            ll mid = (l + r) / 2;
            pll q = query(1, 1, N, i, mid);
            if(q.first - B[i-1] >= suff[i] - suff[mid+1]) {
                best = mid;
                l = mid + 1;
            } else {
                r = mid - 1;
            }
        }
        ans = max(ans, best - i + 1);
    }
    cout << ans << "\n";

    return 0;
}